/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.CrystalMossCoverBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.structures.piece.MountainPiece;
import org.betterx.betterend.world.surface.SplitNoiseCondition;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class CrystalMountainPiece
extends MountainPiece {
    private BlockState top = EndBlocks.CRYSTAL_MOSS.m_49966_();

    public CrystalMountainPiece(BlockPos center, float radius, float height, RandomSource random, Holder<Biome> biome) {
        super(EndStructures.MOUNTAIN_PIECE, center, radius, height, random, biome);
    }

    public CrystalMountainPiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.MOUNTAIN_PIECE, tag);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        super.fromNbt(tag);
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int height;
        int z;
        int x;
        int radius;
        int i;
        int sx = chunkPos.m_45604_();
        int sz = chunkPos.m_45605_();
        BlockPos.MutableBlockPos pos = GlobalState.stateForThread().POS;
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        Heightmap map = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE);
        Heightmap map2 = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int x2 = 0; x2 < 16; ++x2) {
            int px = x2 + sx;
            int px2 = px - this.center.m_123341_();
            px2 *= px2;
            pos.m_142451_(x2);
            for (int z2 = 0; z2 < 16; ++z2) {
                float maxY;
                float dist;
                int pz = z2 + sz;
                int pz2 = pz - this.center.m_123343_();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.m_142443_(z2);
                dist = 1.0f - (float)Math.pow(dist / this.r2, 0.3);
                int minY = map.m_64242_(x2, z2);
                if (minY < 10) continue;
                pos.m_142448_(minY);
                while (!chunk.m_8055_((BlockPos)pos).m_204336_(CommonBlockTags.GEN_END_STONES) && pos.m_123342_() > 56 && chunk.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50627_)) {
                    pos.m_142448_(pos.m_123342_() - 1);
                }
                minY = pos.m_123342_();
                if ((minY = Math.max(minY, map2.m_64242_(x2, z2))) <= this.center.m_123342_() - 8 || !((maxY = dist * this.height * this.getHeightClamp(world, 12, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.8f;
                int maxYI = (int)(maxY += (float)this.center.m_123342_());
                int cover = maxYI - 1;
                double noise = SplitNoiseCondition.DEFAULT.getNoise(px, pz);
                boolean needCover = noise > 0.0;
                boolean needSurroundCover = Math.abs(noise) < 0.2;
                for (int y = minY - 1; y < maxYI; ++y) {
                    pos.m_142448_(y);
                    if (needCover && y == cover) {
                        chunk.m_6978_((BlockPos)pos, this.top, false);
                    } else {
                        chunk.m_6978_((BlockPos)pos, Blocks.f_50259_.m_49966_(), false);
                    }
                    if (!needSurroundCover || !chunk.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_)) continue;
                    BlockState coverState = EndBlocks.CRYSTAL_MOSS_COVER.m_49966_();
                    BlockPos above = pos.m_7494_();
                    boolean didChange = false;
                    for (Direction dir : Direction.values()) {
                        if (!chunk.m_8055_(above.m_121945_(dir)).m_204336_(CommonBlockTags.END_STONES)) continue;
                        coverState = (BlockState)coverState.m_61124_((Property)CrystalMossCoverBlock.m_153933_((Direction)dir), (Comparable)Boolean.valueOf(true));
                        didChange = true;
                    }
                    if (!didChange) continue;
                    chunk.m_6978_(above, coverState, false);
                }
            }
        }
        map = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE);
        int count = (map.m_64242_(8, 8) - (this.center.m_123342_() + 24)) / 7;
        count = Mth.m_14045_((int)count, (int)0, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)2, (int)3, (RandomSource)random);
            float fill = MHelper.randRange((float)0.0f, (float)1.0f, (RandomSource)random);
            x = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random);
            int y = map.m_64242_(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random));
            if (y <= 60) continue;
            pos.m_122178_(x, y, z);
            if (!chunk.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50259_)) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
        count = (map.m_64242_(8, 8) - (this.center.m_123342_() + 24)) / 2;
        count = Mth.m_14045_((int)count, (int)4, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)1, (int)2, (RandomSource)random);
            float fill = random.m_188499_() ? 0.0f : 1.0f;
            x = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random);
            int y = map.m_64242_(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (RandomSource)random));
            if (y <= 20) continue;
            pos.m_122178_(x, y, z);
            if (chunk.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50259_) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
    }

    private void crystal(ChunkAccess chunk, BlockPos pos, int radius, int height, float fill, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int max = MHelper.floor((double)(fill * (float)radius + (float)radius + 0.5f));
        height += pos.m_123342_();
        Heightmap map = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE);
        int coefX = MHelper.randRange((int)-1, (int)1, (RandomSource)random);
        int coefZ = MHelper.randRange((int)-1, (int)1, (RandomSource)random);
        for (int x = -radius; x <= radius; ++x) {
            mut.m_142451_(x + pos.m_123341_());
            if (mut.m_123341_() < 0 || mut.m_123341_() >= 16) continue;
            int ax = Math.abs(x);
            for (int z = -radius; z <= radius; ++z) {
                int az;
                mut.m_142443_(z + pos.m_123343_());
                if (mut.m_123343_() < 0 || mut.m_123343_() >= 16 || ax + (az = Math.abs(z)) >= max) continue;
                int minY = map.m_64242_(mut.m_123341_(), mut.m_123343_()) - MHelper.randRange((int)3, (int)7, (RandomSource)random);
                if (pos.m_123342_() - minY > 8) {
                    minY = pos.m_123342_() - 8;
                }
                int h = coefX * x + coefZ * z + height;
                for (int y = minY; y < h; ++y) {
                    mut.m_142448_(y);
                    chunk.m_6978_((BlockPos)mut, EndBlocks.AURORA_CRYSTAL.m_49966_(), false);
                }
            }
        }
    }
}

